/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContext;
import com.kenai.jffi.CallContextCache;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Closure;
import com.kenai.jffi.ClosurePool;
import com.kenai.jffi.Type;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;

public class ClosureManager {
    private final Map<CallContext, Reference<ClosurePool>> poolMap = new WeakHashMap<CallContext, Reference<ClosurePool>>();

    public static final ClosureManager getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private ClosureManager() {
    }

    public final Closure.Handle newClosure(Closure closure, Type type, Type[] typeArray, CallingConvention callingConvention) {
        return this.newClosure(closure, CallContextCache.getInstance().getCallContext(type, typeArray, callingConvention));
    }

    public final Closure.Handle newClosure(Closure closure, CallContext callContext) {
        ClosurePool closurePool = this.getClosurePool(callContext);
        return closurePool.newClosureHandle(closure);
    }

    private final synchronized ClosurePool getClosurePool(CallContext callContext) {
        ClosurePool closurePool;
        Reference<ClosurePool> reference = this.poolMap.get(callContext);
        if (reference != null && (closurePool = reference.get()) != null) {
            return closurePool;
        }
        closurePool = new ClosurePool(callContext);
        this.poolMap.put(callContext, new SoftReference<ClosurePool>(closurePool));
        return closurePool;
    }

    private static final class SingletonHolder {
        static final ClosureManager INSTANCE = new ClosureManager();

        private SingletonHolder() {
        }
    }
}

